#include "DirectIO.h"

typedef interface tagKDIGIOLib_IKDigitalIo_Interface KDIGIOLib_IKDigitalIo_Interface;

typedef struct tagKDIGIOLib_IKDigitalIo_VTable
{
	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *QueryInterface )( KDIGIOLib_IKDigitalIo_Interface __RPC_FAR * This, 
	                                                         REFIID riid, 
	                                                         void __RPC_FAR *__RPC_FAR *ppvObject);

	ULONG ( STDMETHODCALLTYPE __RPC_FAR *AddRef )( KDIGIOLib_IKDigitalIo_Interface __RPC_FAR * This);

	ULONG ( STDMETHODCALLTYPE __RPC_FAR *Release )( KDIGIOLib_IKDigitalIo_Interface __RPC_FAR * This);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetTypeInfoCount )( KDIGIOLib_IKDigitalIo_Interface __RPC_FAR * This, 
	                                                           UINT __RPC_FAR *pctinfo);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetTypeInfo )( KDIGIOLib_IKDigitalIo_Interface __RPC_FAR * This, 
	                                                      UINT iTInfo, 
	                                                      LCID lcid, 
	                                                      ITypeInfo __RPC_FAR *__RPC_FAR *ppTInfo);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetIDsOfNames )( KDIGIOLib_IKDigitalIo_Interface __RPC_FAR * This, 
	                                                        REFIID riid, 
	                                                        LPOLESTR __RPC_FAR *rgszNames, 
	                                                        UINT cNames, 
	                                                        LCID lcid, 
	                                                        DISPID __RPC_FAR *rgDispId);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *Invoke )( KDIGIOLib_IKDigitalIo_Interface __RPC_FAR * This, 
	                                                 DISPID dispIdMember, 
	                                                 REFIID riid, 
	                                                 LCID lcid, 
	                                                 WORD wFlags, 
	                                                 DISPPARAMS __RPC_FAR *pDispParams, 
	                                                 VARIANT __RPC_FAR *pVarResult, 
	                                                 EXCEPINFO __RPC_FAR *pExcepInfo, 
	                                                 UINT __RPC_FAR *puArgErr);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *OpenDevice_) (KDIGIOLib_IKDigitalIo_Interface __RPC_FAR *This, 
	                                                     BSTR driver, 
	                                                     long device);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *CloseDevice_) (KDIGIOLib_IKDigitalIo_Interface __RPC_FAR *This);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *Read_) (KDIGIOLib_IKDigitalIo_Interface __RPC_FAR *This, 
	                                               short offset, 
	                                               unsigned char *__returnValue);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *Write_) (KDIGIOLib_IKDigitalIo_Interface __RPC_FAR *This, 
	                                                short offset, 
	                                                unsigned char value);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetDriver_) (KDIGIOLib_IKDigitalIo_Interface __RPC_FAR *This, 
	                                                    BSTR *__returnValue);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetDevice_) (KDIGIOLib_IKDigitalIo_Interface __RPC_FAR *This, 
	                                                    long *__returnValue);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetOpenCount_) (KDIGIOLib_IKDigitalIo_Interface __RPC_FAR *This, 
	                                                       long *__returnValue);

} KDIGIOLib_IKDigitalIo_VTable;

typedef interface tagKDIGIOLib_IKDigitalIo_Interface
{
	CONST_VTBL KDIGIOLib_IKDigitalIo_VTable __RPC_FAR *lpVtbl;
} KDIGIOLib_IKDigitalIo_Interface;

HRESULT CVIFUNC KDIGIOLib_NewIKDigitalIo (const char *server,
                                          int supportMultithreading, LCID locale,
                                          int reserved,
                                          CAObjHandle *objectHandle)
{
	HRESULT __result;
	GUID clsid = {0x25B3BFD0, 0x6150, 0x11D3, 0x9D, 0x1D, 0x0, 0xA0, 0xC9, 0x5,
	              0x9, 0x77};
	GUID iid = {0x25B3BFCF, 0x6150, 0x11D3, 0x9D, 0x1D, 0x0, 0xA0, 0xC9, 0x5,
	            0x9, 0x77};

	__result = CA_CreateObjectByClassIdEx (&clsid, server, &iid,
	                                       supportMultithreading, locale,
	                                       reserved, objectHandle);

	return __result;
}

HRESULT CVIFUNC KDIGIOLib_OpenIKDigitalIo (const char *fileName,
                                           const char *server,
                                           int supportMultithreading,
                                           LCID locale, int reserved,
                                           CAObjHandle *objectHandle)
{
	HRESULT __result;
	GUID clsid = {0x25B3BFD0, 0x6150, 0x11D3, 0x9D, 0x1D, 0x0, 0xA0, 0xC9, 0x5,
	              0x9, 0x77};
	GUID iid = {0x25B3BFCF, 0x6150, 0x11D3, 0x9D, 0x1D, 0x0, 0xA0, 0xC9, 0x5,
	            0x9, 0x77};

	__result = CA_LoadObjectFromFileByClassIdEx (fileName, &clsid, server,
	                                             &iid, supportMultithreading,
	                                             locale, reserved,
	                                             objectHandle);

	return __result;
}

HRESULT CVIFUNC KDIGIOLib_ActiveIKDigitalIo (const char *server,
                                             int supportMultithreading,
                                             LCID locale, int reserved,
                                             CAObjHandle *objectHandle)
{
	HRESULT __result;
	GUID clsid = {0x25B3BFD0, 0x6150, 0x11D3, 0x9D, 0x1D, 0x0, 0xA0, 0xC9, 0x5,
	              0x9, 0x77};
	GUID iid = {0x25B3BFCF, 0x6150, 0x11D3, 0x9D, 0x1D, 0x0, 0xA0, 0xC9, 0x5,
	            0x9, 0x77};

	__result = CA_GetActiveObjectByClassIdEx (&clsid, server, &iid,
	                                          supportMultithreading, locale,
	                                          reserved, objectHandle);

	return __result;
}

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoOpenDevice (CAObjHandle objectHandle,
                                                 ERRORINFO *errorInfo,
                                                 const char *driver, long device)
{
	HRESULT __result;
	KDIGIOLib_IKDigitalIo_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x25B3BFCF, 0x6150, 0x11D3, 0x9D, 0x1D, 0x00, 0xA0, 0xC9, 0x05, 0x09, 0x77};
	int __didAddRef;
	int __errorInfoPresent;
	BSTR driver__AutoType = 0;

	__caErrChk (CA_CStringToBSTR (driver, &driver__AutoType));

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->OpenDevice_ (__dualIFacePtr,
	                                                 driver__AutoType, device));

Error:
	CA_FreeBSTR (driver__AutoType);
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoCloseDevice (CAObjHandle objectHandle,
                                                  ERRORINFO *errorInfo)
{
	HRESULT __result;
	KDIGIOLib_IKDigitalIo_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x25B3BFCF, 0x6150, 0x11D3, 0x9D, 0x1D, 0x00, 0xA0, 0xC9, 0x05, 0x09, 0x77};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->CloseDevice_ (__dualIFacePtr));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoRead (CAObjHandle objectHandle,
                                           ERRORINFO *errorInfo, short offset,
                                           unsigned char *returnValue)
{
	HRESULT __result;
	KDIGIOLib_IKDigitalIo_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x25B3BFCF, 0x6150, 0x11D3, 0x9D, 0x1D, 0x00, 0xA0, 0xC9, 0x05, 0x09, 0x77};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->Read_ (__dualIFacePtr, offset,
	                                           returnValue));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoWrite (CAObjHandle objectHandle,
                                            ERRORINFO *errorInfo, short offset,
                                            unsigned char value)
{
	HRESULT __result;
	KDIGIOLib_IKDigitalIo_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x25B3BFCF, 0x6150, 0x11D3, 0x9D, 0x1D, 0x00, 0xA0, 0xC9, 0x05, 0x09, 0x77};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->Write_ (__dualIFacePtr, offset, value));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoGetDriver (CAObjHandle objectHandle,
                                                ERRORINFO *errorInfo,
                                                char **returnValue)
{
	HRESULT __result;
	KDIGIOLib_IKDigitalIo_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x25B3BFCF, 0x6150, 0x11D3, 0x9D, 0x1D, 0x00, 0xA0, 0xC9, 0x05, 0x09, 0x77};
	int __didAddRef;
	int __errorInfoPresent;
	BSTR  returnValue__AutoType = 0;

	*returnValue = 0;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->GetDriver_ (__dualIFacePtr,
	                                                &returnValue__AutoType));

	if (returnValue)
		__caErrChk (CA_BSTRGetCString (returnValue__AutoType, returnValue));

Error:
	CA_FreeBSTR (returnValue__AutoType);
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	if (FAILED(__result))
		{
		CA_FreeMemory (*returnValue);
		*returnValue = 0;
		}
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoGetDevice (CAObjHandle objectHandle,
                                                ERRORINFO *errorInfo,
                                                long *returnValue)
{
	HRESULT __result;
	KDIGIOLib_IKDigitalIo_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x25B3BFCF, 0x6150, 0x11D3, 0x9D, 0x1D, 0x00, 0xA0, 0xC9, 0x05, 0x09, 0x77};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->GetDevice_ (__dualIFacePtr,
	                                                returnValue));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoGetOpenCount (CAObjHandle objectHandle,
                                                   ERRORINFO *errorInfo,
                                                   long *returnValue)
{
	HRESULT __result;
	KDIGIOLib_IKDigitalIo_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x25B3BFCF, 0x6150, 0x11D3, 0x9D, 0x1D, 0x00, 0xA0, 0xC9, 0x05, 0x09, 0x77};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->GetOpenCount_ (__dualIFacePtr,
	                                                   returnValue));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}
